var svgScroller_svgList,
	svgScroller_lastUsed

function svgScroller_init()
{
	svgScroller_svgList = {}

	var texts =
	[
		{
			id:'endScroller'
			,color:'#fff'
			,text:'\n'
				+'\n\nYou just watched\nNEJA NOVA\nthe javascript only demo\n\n'
			,path:"M10 50 C10 0 90 0 90 50"
		},
		{
			id:'greetings'
			,color:'#0f0'
			,text:'\n, Opera and the Assembly crew'
			,path:"M10 50 C10 0 90 0 90 50"
		}
	]

	for( var i=0,currentText; currentText=texts[i]; i++ )
	{
		var svgns = "http://www.w3.org/2000/svg";
		var xlinkns = "http://www.w3.org/1999/xlink";

		svgScroller_svgList[ currentText.id ]		= createSVGElement
			(
				'svg',
				{
					width:640,
					height:320,
					xmlns:'http://www.w3.org/2000/svg',
					viewBox:'0 0 640 320',

					style:'position:absolute;width:640px;height:320px;z-index:0;display:none;'
				}
			)

	    var defs = createSVGElement( "defs" );
	    var path = createSVGElement( "path",
	    	{
	    		id:'textPath',
	    		d:currentText.path
	    	});


	    path.setAttributeNS( null, "id", "textPath" );
	    path.setAttributeNS( null, "d", "M 0,0 t 160,0 320,0 " );

	    defs.appendChild( path );
	    svgScroller_svgList[ currentText.id ].appendChild( defs );

	    var text		= createSVGElement( 'text', {'fill':currentText.color,'font-size':24})
	    var textPath	= createSVGElement( 'textPath' );
	    textPath.setAttributeNS( 'http://www.w3.org/1999/xlink', 'xlink:href', '#textPath' );

	    var tmp = currentText.text.split( '\n' )
	    for( var lineIndex=0;lineIndex<tmp.length;lineIndex++ )
	    {
	    	var currentLine=tmp[lineIndex]
		    var tSpan	= createSVGElement( 'tspan',
		    {
		    	x:0,
		    	dy:'1em'
		    	} );

	    	tSpan.appendChild( document.createTextNode( currentLine+String.fromCharCode(160) ) );
		    textPath.appendChild( tSpan );
	    }

	    text.appendChild( textPath );
	    svgScroller_svgList[ currentText.id ].appendChild( text );

	    renderAreaHandle.appendChild( svgScroller_svgList[ currentText.id ] )
	}


	//	done
	progressBarIndex++;
}


function svgScroller_render( currentTime, percentage, scrollId )
{
	offScreenCanvasContext.clearRect( 0,0,320,160 )

	if( svgScroller_lastUsed )
		svgScroller_lastUsed.style.disapy='none';

	svgScroller_lastUsed = svgScroller_svgList[ scrollId ]

	if( svgScroller_lastUsed.style.display=='none' )
		svgScroller_lastUsed.style.display='block'

	var theUsefulNode = svgScroller_lastUsed.firstChild.nextSibling.firstChild.firstChild

	if( scrollId=='endScroller' )
	{
		theUsefulNode.setAttribute( 'dy', (1-20*percentage) +'em' )
	}


}

function svgScroller_destroy()
{
	if( svgScroller_lastUsed )
		svgScroller_lastUsed.style.disapy='none';

}

